"use strict";

/* //////////////////////////////////////////////
 

 JavaScript 
 ライブラリを使ったアニメーション(TweenMax)
 
 ● 公式ドキュメント
 https://greensock.com/docs/TweenMax

 ● 参考記事
 http://un-tech.jp/tweenmax-started/
 http://www.mdesign-works.com/blog/web/tween-max/
 http://misc.laboradian.com/tweenmax-sample/001/
 
////////////////////////////////////////////// */

document.addEventListener( "DOMContentLoaded", function() {
	animation();
},false);


function animation() {
	const button1 = document.getElementById("move1");
	button1.addEventListener("click", function() {
		// TweenMaxを使ってアニメーション
		TweenMax.to(
			"#box" , // 要素のセレクタ
			0.5 , // 動く秒数
			{
				left : 200 , // CSSのプロパティ left
				width: 250,
				height: 250,
				backgroundColor: '#0000ff',
				rotation: 90,
				delay : 0 , // 実行までの待ち時間
				ease : Power2.easeInOut , // イージング ＊一覧 https://greensock.com/docs/Easing
				repeat: 1, // 繰り返す数 ＊0なら1回だけ動く
				yoyo: true, // 元に戻るか
			}
		);
	});

	/**
	 * 他のボタンにもアニメーション処理を登録する
	 */
	const button2 = document.getElementById("move2");
	button2.addEventListener("click", function() {
		// ここで動かす
	});
}
