"use strict"; // <- なるべくいれておく

/* //////////////////////////////////////////////
 

 JavaScript 基礎構文のサンプル


////////////////////////////////////////////// */


/* ==============================================
 * 変数宣言/代入
 * let - 再代入する予定の変数宣言
 * const - 定数など変わらない値を宣言
 * var - 汎用変数宣言
 ============================================== */
// let で myText という変数を宣言
let myText = "テキスト";

// letのほか const, var
const myName = "山田タロウ";

alert(myText);

// 宣言済みの変数に新たに代入
myText = "新しいテキスト";

/* ~~~~~~~~~~~~~~~~~~~~~~~~ 
 ⚠️ 同じ名前の変数は "1度だけ" 宣言可能
~~~~~~~~~~~~~~~~~~~~~~~~ */
// もう一度宣言するとエラーになる
// let myText = "新しく宣言"; // -> エラー

// const で宣言した変数は内容を変更できない
// myName = "山田ハナコ"; // -> エラー 

/* ==============================================
 * 型
 ============================================== */
// String型 ＊文字
let myStirng = "文字列";

// Number型 ＊数字
let myNumber = 999; //""コーテーションはいらない

// Boolean型 ＊真偽
let myBoolean = true; // true か false

// Fuction型 ＊関数
let myFunc = function() {
	alert("hello!");
};
// Array型 ＊配列
let myArray = ["aaa", "bbb", "ccc"];
// 開発用のコンソールに出力
console.log(myArray); // -> (3) { ... }

// Object型 ＊オブジェクト
let myObject = {
	name: "山田タロウ",
	age: 20,
	sex: "male",
	blood: "B",
	hasPC: false
};
// 開発用のコンソールに出力
console.log(myObject); // -> object { ... }

/* ==============================================
 * 関数の宣言と実行
 * https://developer.mozilla.org/ja/docs/Web/JavaScript/Reference/Operators/function
 ============================================== */

// Fuction型 ＊関数
function myFunc3() {
	alert("hello!");
}
// 以下も同じ意味
let myFunc2 = function() {
	alert("hello!");
};

// 引数をとる関数
function myFunc3(name) {
	alert("hello! " + name);
}
// 関数の実行
myFunc3("山田");

// returnで値を返す関数
function getMessage(name) {
	let message = "こんにちは。" + name + "です。";
	return message;
}

// 実行して値を変数に保存
let myMessage = getMessage("山田");
console.log(myMessage); // -> こんにちは。山田です。

/* ==============================================
 * 算術演算子
 * https://developer.mozilla.org/ja/docs/Web/JavaScript/Reference/Operators/Arithmetic_Operators
 ============================================== */
// 加算 減算
let mathA = 4;
let mathB = mathA + 6; //10
let mathC = mathB - 20; //-10
// 変数に +1 または -1するときは以下の様にかける
mathA++ //5
mathA-- //4

// 乗算
let mathD = 5 * mathB; //-50

// 除算
let mathE = mathD / 2; //-25

//文字列も加算のみ可能
let mathText = "こんにちは。" + "山田です。"; //  "こんにちは。山田です。"

//文字列と数字を加算すると文字列になる
let mathText2 = "わたしは" +  20 + "歳です"; //  "こんにちは。山田です。"


/* ==============================================
 * if文と比較演算子
 * https://asciidwango.github.io/js-primer/basic/condition/
 ============================================== */

if (mathA === 4) {
	// mathAが4と等しかった場合
	console.log("mathAは4です");
} else {
	// その他の場合
	console.log("mathAは4ではないです");
}
// ! をつけると否定
if (mathA !== 4) {
	// mathAが4ではない
	console.log("mathAは4ではないです");
}

if (mathB > 10) {
	// mathBが10より大きい場合
	console.log("mathBは10より大きいです");
}

// && で繋ぐと XXX かつ YYY という意味
if (0 < mathA && mathA < 20) {
	console.log("mathAは0より大きく、20より小さい");
}
// || で繋ぐと XXX または YYY という意味
if (100 < mathB || mathB === 0) {
	console.log("mathBは100より大きいか、0です");
} else {
	console.log("mathBは100より小さく、0ではないです");
}

// 比較演算子なしの場合は "", 0, false, null ,undefind  以外のときに trueになる
const message = "";
if ( message ) {

} else {
	console.log("メッセージはなし");
}

/* ==============================================
 * 配列の取り扱い
 ============================================== */
// 配列は最初から順に番号(index)がついている
// indexは　"0"　"から始まる
let myFavoriteFood = [
	"カレー", //0
	"うどん", //1
	"ケーキ", //2
	"からあげ", //3
	"すし" //4
];
console.log(myFavoriteFood);
// 変数名に [番号] をつけるとそのindexを取得できる
console.log(myFavoriteFood[2]); // ->　ケーキ

// 末尾に .length をつけると配列の数を取得できる
console.log(myFavoriteFood.length); // -> 5


/* ==============================================
 * オブジェクトの扱い
 ============================================== */

// オブジェクトは key: value(値) で表す
// valueはあらゆる型が入れられる
// name,age .. などをオブジェクトのメンバーという
let myProfile = {
	// 文字・数字・true/falseなど様々な型が可能(プロパティ)
	name: "山田タロウ",
	age: 20,
	sex: "male",
	blood: "B",
	hasPC: false,
	//関数もvaluに入れることができる(メソッド)
	myMessage: function(name) {
		let message = "こんにちは。" + name + "です。";
		return message;
	}
};
// 変数名に ドット "." とメンバー名をつけるとメンバーにアクセス可能
console.log( myProfile.name ); // -> 山田タロウ
console.log( myProfile.myMessage("山田") ); // -> こんにちは。山田です。
// 配列と同じ様に [] でもアクセス可能
console.log( myProfile["name"] ); // -> 山田タロウ



/* ==============================================
 * 配列とオブジェクトの組み合わせ
 ============================================== */
let myFamily = [
	{
		name: "山田タロウ",
		age: 20,
		sex: "male",
	},
	{
		name: "山田ハナコ",
		age: 41,
		sex: "female",
	},
	{
		name: "山田イチロー",
		age: 42,
		sex: "male",
	},
]
// 配列の [番号] と　オブジェクトの ドット　"."の組み合わせ
console.log( myFamily[1].name ); //->山田ハナコ

/* ==============================================
 * ループ for文 
 ============================================== */

// index 0 から 1 2 3 ... と順番に処理されていく
for (let index = 0; index < myFavoriteFood.length; index++) {
	const food = myFavoriteFood[index];
	console.log(index + "番：" + food); // -> 0番: カレー ....
}

// break 途中でやめる
for (let index = 0; index < myFavoriteFood.length; index++) {
	const food = myFavoriteFood[index];
	console.log(index + "番：" + food);
	//ケーキまできたら終わる
	if(food === "ケーキ"){
		break;
	}
}

/* ==============================================
 * スコープ
 * 変数の参照する範囲
 * グローバルスコープとローカルスコープがある
 * https://asciidwango.github.io/js-primer/basic/function-scope/
 
 ============================================== */

function getSecretName(){
	//ローカル変数
	const secretName = "秘密の名前";
	return secretName;
}
// function内で定義された変数は外から取得できない
console.log(secretName); // エラー　"secret is not defined" 定義されてません。

//グローバル変数
const firstName = "田中";
function getFullname(){
	// どこでも取得できる
	console.log(firstName); // 田中
}


/* //////////////////////////////////////////////
 

ここでは代表的なごく一部の機能のみ紹介してます。
詳しくは以下などを参照
https://asciidwango.github.io/js-primer/basic/


////////////////////////////////////////////// */




