"use strict";

/* //////////////////////////////////////////////
 

 JavaScript DOM / EVENT

 DOM : JSからHTMLの要素を取得する仕組み
	＊詳しくは https://eng-entrance.com/what-is-dom

////////////////////////////////////////////// */

/* ==============================================
 * 
 * window オブジェクト
 * 
 * ブラウザの大元のオブジェクト
 * ウインドウのメタ情報（ウインドウサイズなど）などが入ってる
 ============================================== */
console.log(window);

// グローバルに関数を追加するとwindowオブジェクトに追加される
function getPageTitle() {
	return "JSでDOMの操作";
}
console.log(window.getPageTitle()); // <- JSでDOMの操作

//その他いろんなプロパティ・メソッドが入ってる
console.log(window.innerWidth); // ウインドウの幅
console.log(window.innerHeight); // ウインドウの高さ

/* ==============================================
 * 
 * document オブジェクト
 * 
 * DOMの大元のオブジェクト
 * htmlの要素が入ってる
 ============================================== */
console.log(document);


/* ==============================================
 * 
 * DOMがJSで扱えるようになるのを待つイベント
 * DOMContentLoaded を登録
 ============================================== */

document.addEventListener("DOMContentLoaded", function(){
	// ここにDOMを使う処理を書く

	// domHandler();
	// addEventHandler();
});

/* ==============================================
 * 
 * DOMの取得
 * 
 * よく使う取得方法は以下の3つ
 * document.getElementById("id"); // 一つだけ 一番早い
 * document.querySelector("selector"); // 最初の一つの要素
 * document.querySelectorAll("selector"); // 要素の配列で取得
 * 
 * ⚠️ DOMは ページが構成されてからでないと取得できないので
 * 　DOMContentLoaded後に行う
 ============================================== */

function domHandler() {
	/**
	 * DOMの取得
	 */
	// body要素の取得
	const body = document.body;
	console.log(body);

	// idが "mainTitle"の要素を取得
	const mainTitle = document.getElementById("mainTitle");
	console.log(mainTitle);

	// classが "message"の要素を1つだけ取得
	const message = document.querySelector(".message");
	console.log(message);

	// classが "list"の要素をすべて取得
	const list = document.querySelectorAll(".list");
	console.log(list); // nodeList
	
	/**
	 * DOMの操作
	 */

	// bodyの背景を赤に
	body.style.backgroundColor = "#FF0000";

	// 中身の書き換え
	mainTitle.innerHTML = getPageTitle();

	// classを追加
	message.classList.add("active");
	message.innerHTML = "クラス追加されました！"

	// querySelectorAllで取得した要素配列をfor文で一つ一つ取り出す
	for (let index = 0; index < list.length; index++) {
		const element = list[index];
		console.log(element);
		element.innerText = index + "番目の要素"
		element.style.color = "#FFFFFF";
		
	}


}
/* ==============================================
 * 
 * event 
 * 
 * ユーザーのアクション、ページの読み込みなどを検知する
 * 
 * ● 基本構文
 * object.addEventListener("イベント名","イベントが起こったら呼ばれる関数");
 * 
 ============================================== */
function addEventHandler(){

	/**
	 * クリックイベント
	 */
	// #btnの要素を取得
	const button = document.getElementById("btn");
	// buttonに addEventListener で要素にイベントを登録
	button.addEventListener("click", function(event){
		console.log(event);
		document.body.style.backgroundColor = "#00FF00";
	});

	/**
	 * マウスムーブ
	 */
	const posView = document.querySelector("div.mousePos");
	// buttonに addEventListener で要素にイベントを登録
	document.addEventListener("mousemove", function(event){
		console.log(event);
		posView.innerHTML = `上から:${event.clientY}px／左から:${event.clientX}px`;
	});
 
}







