"use strict";

/* //////////////////////////////////////////////
 

 JavaScript 
 ライブラリを使ったアニメーション(TweenMax)
 
 ● 公式ドキュメント
 https://greensock.com/docs/TweenMax

 ● 参考記事
 http://un-tech.jp/tweenmax-started/
 http://www.mdesign-works.com/blog/web/tween-max/
 http://misc.laboradian.com/tweenmax-sample/001/
 
////////////////////////////////////////////// */

document.addEventListener( "DOMContentLoaded", function() {
	animation();
},false);


function animation() {
	/**
	 * アニメーション1
	 */
	const button1 = document.getElementById("move1");
	button1.addEventListener("click", function() {
		// TweenMaxを使ってアニメーション
		TweenMax.to(
			"#box1" , // 要素のセレクタ
			0.5 , // 動く秒数
			{
				x : 200 , // CSSのプロパティ left
				scale: 2,
				rotation: 90,
				backgroundColor: '#0000ff',
				delay : 0 , // 実行までの待ち時間
				ease : Power2.easeOut , // イージング ＊一覧 https://greensock.com/docs/Easing
				repeat: 1, // 繰り返す数 ＊0なら1回だけ動く
				yoyo: true, // 元に戻るか
			}
		);
	});

	/**
	 * アニメーション2
	 * 複数の動きをつける
	 */
	const button2 = document.getElementById("move2");
	button2.addEventListener("click", function() {
		// 初期状態をセット
		TweenMax.set(
			"#box2" , 
			{
				x : 0 , 
				y: 0,
				rotation: 0,
				scale: 1,
				backgroundColor: "#FF0000"
			}
		);
		// 最初のアニメーション
		TweenMax.to(
			"#box2" ,
			0.5 , // 動く秒数
			{
				x : 400 , // transform: translateX
				rotation: 90, // transform: rotate
				ease : Power2.easeInOut , 
				
			}
		);
		// 0.5秒遅れて実行
		TweenMax.to(
			"#box2" ,
			0.5 , // 動く秒数
			{
				x : 150 , // transform: translateX
				rotation: 0,
				ease : Power2.easeInOut , 
				delay : 0.5 , //待ち時間
				
			}
		);
		// 1秒遅れて実行
		TweenMax.to(
			"#box2" ,
			0.5 , // 動く秒数
			{

				rotation: +720,
				scale: 2,
				ease : Power2.easeIn, 
				backgroundColor:'#00FF00',
				delay : 1, //待ち時間
				repeat: 5, //繰り返し
				yoyo: true,
			}
		);
	});

	/**
	 * アニメーション3
	 * 複数の要素を動かす
	 */
	const button3 = document.getElementById("move3");
	button3.addEventListener("click", function() {
		// TweenMax.staggerTo で複数アニメーション
		TweenMax.staggerTo(
			"#box3 .box-item",
			0.6 , // 動く秒数
			{
				x: 400,
				ease :  Expo.easeInOut , 
				backgroundColor:'#00FF00',
				repeat: 1, // 繰り返す数 ＊0なら1回だけ動く
				yoyo: true, // 元に戻るか
			},
			0.1 // 要素ごとのアニメーションする間隔
		);
	});

	/**
	 * アニメーション4
	 * ランダムに動かす
	 */
	const button4 = document.getElementById("move4");
	button4.addEventListener("click", function() {
		TweenMax.set(
			"#box4 .box-item",
			{
				x:0,
				rotation: 0,
			}
		)
		TweenMax.staggerTo(
			"#box4 .box-item",
			0.6 , // 動く秒数
			{
				x: function() {
					return Math.random() * 500; // 0〜500
				},
				rotation: function(){
					return Math.random() * 400; //0〜400
				},
				ease : Power2.easeInOut , 
				repeat: 1, // 繰り返す数 ＊0なら1回だけ動く
				yoyo: true, // 元に戻るか
			},
			0.3 // 要素ごとのアニメーションする間隔
		);
	});
}
