"use strict";

/* //////////////////////////////////////////////
 

 JavaScript 消費税計算機をつくってみる


////////////////////////////////////////////// */

document.addEventListener("DOMContentLoaded",function() {
	calculator();
},false);

function calculator() {
	// DOM(要素)を取得して変数に代入しておく
	const price = document.getElementById("price");
	const rate = document.getElementById("rate");
	const button = document.getElementById("runCalc");
	const result = document.getElementById("result");

	// #runCalc にクリックイベントを登録
	button.addEventListener("click",function(){
		// 価格・税率の入力を取得
		let priceNum = price.value;
		let rateNum = rate.value;
		
		// 価格・税率から税込価格を計算
		let resultValue = priceNum * ( rateNum / 100 + 1);

		// 価格の小数点以下を四捨五入 | Math.round()
		resultValue = Math.round(resultValue);

		// span#result の中身を書き換え
		result.innerHTML = resultValue;
	})

}
