"use strict";

/* //////////////////////////////////////////////
 

 JavaScript 
 for文で多数のHTMLを生成


////////////////////////////////////////////// */
/*

● for文の書き方 ( [indexを宣言]; [条件式]; [終わったらindexに1を足す] )
	(例) 10回ループする
	for( let index = 0; index < 10; index++ ){
		//処理例
		let number = index + "番です";
	}

● HTML要素の作成 createElement("タグ名")
	let newElement = document.createElement("div"));


● HTML要素を末尾に追加 appendChild(Element);
	containerElement.appendChild( newElement );

*/

document.addEventListener(
	"DOMContentLoaded",
	function() {
		creatElements();
	},
	false
);


function creatElements() {
	// 1. #containerと #createを取得して変数に代入
	const containerElement = document.getElementById("container");
	const createBtn = document.getElementById("create");

	// 2. ボタンにクリックイベントを登録
	createBtn.addEventListener("click", function() {
		// 3. for文で任意の数をループ
		for (let index = 0; index < 500; index++) {
			// 4. document.createElement() で div要素の作成 & innerHTMLでテキストを追加
			let divElement = document.createElement("div");
			divElement.innerHTML = index + "番です";
			// 5. appendChild() で 作成した要素を #containerに追加
			containerElement.appendChild(divElement);
		}
	});
}
