"use strict";

/* //////////////////////////////////////////////
 

 JavaScript 
 ランダムに画像を変更


////////////////////////////////////////////// */
/*

● ランダムな数の取得
	Math.random() // 0〜1未満のランダムな少数を取得 ( 0 から 0.9999 )
	Math.floor() // 小数点以下を切り捨て

	(例)0〜9のランダムな数
	let random = Math.floor( Math.random() * 10 );

	(例)5〜20のランダムな数
	let random = Math.floor( Math.random() * (21 - 5) + 5 );


● 配列へのアクセス Array[num]
	let arraySample = ["A","B","C"];
	let arrNum1 = arraySample[1]; // B

	// 変数(整数)を []に入れることもできる
	let num = 2;
	let arrNumVar = arraySample[num]; // C

● 配列の要素の数を取得 
	let arrLength = arraySample.length; // 3
	
● 画像の"src"の取得・書き換え Element.src
	let imgElm = document.querySelector("img.change"));
	imageElm.src = "images/newimage.jpg";


*/

document.addEventListener("DOMContentLoaded",function() {
		randomImage();
},false);


function randomImage() {
	// 画像のパスの配列を宣言
	const vegetableList = [
		"images/hakusai.png", // [0]
		"images/kabocha.png", // [1]
		"images/ninjin.png", // [2]
		"images/shimeji.png", // [3]
		"images/tamanegi.png" // [4]
	];

	// 1. 画像#image とボタン #changeImage を取得して変数に代入
	const vegetable = document.getElementById("vegetable");
	const changeBtn = document.getElementById("changeVegetable");

	// 2. ボタンにクリックイベントを登録
	changeBtn.addEventListener("click",function(){
		// 3. ランダムな数からvegetableList配列の画像を取得
		let maxNum = vegetableList.length - 1;
		let randomNum = getRandomNumber(0, maxNum);
		let randomImageSrc = vegetableList[randomNum];
		// 4. image のsrcを書き換え
		vegetable.src = randomImageSrc;
	})

}

/**
 * ランダムな整数を取得
 * @param {Number} min 最小値の整数
 * @param {Number} max 最大値の整数
 */
function getRandomNumber(min, max) {
	let random = Math.random() * (max + 1 - min) + min;
	return Math.floor( random );
}

